﻿using System.Linq;

namespace VA.PPMS.IWS.Common
{
    public static class HttpUtility
    {
        public static DasMessage ParseHeaders(System.Net.Http.HttpRequestMessage request)
        {
            if (request == null) return new DasMessage();

            var conversationId = request.Headers.GetValues("X-ConversationID").FirstOrDefault();
            var routingSenderId = request.Headers.GetValues("X-RoutingSenderID").FirstOrDefault();
            var routingReceiverIds = request.Headers.GetValues("X-RoutingReceiverIDs").FirstOrDefault();
            var transactionId = request.Headers.GetValues("X-TransactionID").FirstOrDefault();

            return new DasMessage(conversationId, routingSenderId, routingReceiverIds, transactionId);
        }
    }
}